package io.fabric8.kubernetes.api.model.v1;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ScaleSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractScaleSpecAssert<S extends AbstractScaleSpecAssert<S, A>, A extends ScaleSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractScaleSpecAssert}</code> to make assertions on actual ScaleSpec.
   * @param actual the ScaleSpec we want to make assertions on.
   */
  protected AbstractScaleSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ScaleSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual ScaleSpec's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ScaleSpec's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ScaleSpec's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ScaleSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
