package io.fabric8.kubernetes.api.model.storage.v1beta1;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link VolumeNodeResources} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeNodeResourcesAssert<S extends AbstractVolumeNodeResourcesAssert<S, A>, A extends VolumeNodeResources> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeNodeResourcesAssert}</code> to make assertions on actual VolumeNodeResources.
   * @param actual the VolumeNodeResources we want to make assertions on.
   */
  protected AbstractVolumeNodeResourcesAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual VolumeNodeResources we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual VolumeNodeResources's count is equal to the given one.
   * @param count the given count to compare the actual VolumeNodeResources's count to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeNodeResources's count is not equal to the given one.
   */
  public S hasCount(Integer count) {
    // check that actual VolumeNodeResources we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting count of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCount = actual.getCount();
    if (!Objects.areEqual(actualCount, count)) {
      failWithMessage(assertjErrorMessage, actual, count, actualCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
