package io.fabric8.kubernetes.api.model.storage.v1beta1;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CSINodeSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCSINodeSpecAssert<S extends AbstractCSINodeSpecAssert<S, A>, A extends CSINodeSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCSINodeSpecAssert}</code> to make assertions on actual CSINodeSpec.
   * @param actual the CSINodeSpec we want to make assertions on.
   */
  protected AbstractCSINodeSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CSINodeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property drivers so that assertions can be done on it
   */
  public NavigationListAssert<CSINodeDriver, CSINodeDriverAssert> drivers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<CSINodeDriver, CSINodeDriverAssert> assertFactory = new AssertFactory<CSINodeDriver, CSINodeDriverAssert>() {
      public CSINodeDriverAssert createAssert(CSINodeDriver t) {
        return (CSINodeDriverAssert) assertThat(t);
      }
    };
    NavigationListAssert<CSINodeDriver, CSINodeDriverAssert> answer = new NavigationListAssert<CSINodeDriver, CSINodeDriverAssert>(actual.getDrivers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "drivers"));
    return answer;
  }


}
