package io.fabric8.kubernetes.api.model.storage.v1beta1;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CSINodeDriver} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCSINodeDriverAssert<S extends AbstractCSINodeDriverAssert<S, A>, A extends CSINodeDriver> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCSINodeDriverAssert}</code> to make assertions on actual CSINodeDriver.
   * @param actual the CSINodeDriver we want to make assertions on.
   */
  protected AbstractCSINodeDriverAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CSINodeDriver we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allocatable so that assertions can be done on it
   */
  public VolumeNodeResourcesAssert allocatable()  {
    // check that actual CSINodeDriver we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (VolumeNodeResourcesAssert) assertThat(actual.getAllocatable()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allocatable"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual CSINodeDriver we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property nodeID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert nodeID()  {
    // check that actual CSINodeDriver we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNodeID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeID"));
  }


  /**
   * Navigates to the property topologyKeys so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> topologyKeys()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getTopologyKeys(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "topologyKeys"));
    return answer;
  }


}
