package io.fabric8.kubernetes.api.model.storage.v1beta1;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CSIDriverSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCSIDriverSpecAssert<S extends AbstractCSIDriverSpecAssert<S, A>, A extends CSIDriverSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCSIDriverSpecAssert}</code> to make assertions on actual CSIDriverSpec.
   * @param actual the CSIDriverSpec we want to make assertions on.
   */
  protected AbstractCSIDriverSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CSIDriverSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property attachRequired so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert attachRequired()  {
    // check that actual CSIDriverSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAttachRequired()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attachRequired"));
  }


  /**
   * Navigates to the property podInfoOnMount so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert podInfoOnMount()  {
    // check that actual CSIDriverSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getPodInfoOnMount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podInfoOnMount"));
  }


  /**
   * Navigates to the property volumeLifecycleModes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> volumeLifecycleModes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getVolumeLifecycleModes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeLifecycleModes"));
    return answer;
  }


}
