package io.fabric8.kubernetes.api.model.storage;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link VolumeAttachmentStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeAttachmentStatusAssert<S extends AbstractVolumeAttachmentStatusAssert<S, A>, A extends VolumeAttachmentStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeAttachmentStatusAssert}</code> to make assertions on actual VolumeAttachmentStatus.
   * @param actual the VolumeAttachmentStatus we want to make assertions on.
   */
  protected AbstractVolumeAttachmentStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual VolumeAttachmentStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property attachError so that assertions can be done on it
   */
  public VolumeErrorAssert attachError()  {
    // check that actual VolumeAttachmentStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (VolumeErrorAssert) assertThat(actual.getAttachError()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attachError"));
  }


  /**
   * Navigates to the property attached so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert attached()  {
    // check that actual VolumeAttachmentStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAttached()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attached"));
  }


  /**
   * Navigates to the property attachmentMetadata so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert attachmentMetadata()  {
    // check that actual VolumeAttachmentStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAttachmentMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attachmentMetadata"));
  }


  /**
   * Navigates to the property detachError so that assertions can be done on it
   */
  public VolumeErrorAssert detachError()  {
    // check that actual VolumeAttachmentStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (VolumeErrorAssert) assertThat(actual.getDetachError()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "detachError"));
  }


}
