package io.fabric8.kubernetes.api.model.storage;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link VolumeAttachmentSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeAttachmentSpecAssert<S extends AbstractVolumeAttachmentSpecAssert<S, A>, A extends VolumeAttachmentSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeAttachmentSpecAssert}</code> to make assertions on actual VolumeAttachmentSpec.
   * @param actual the VolumeAttachmentSpec we want to make assertions on.
   */
  protected AbstractVolumeAttachmentSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual VolumeAttachmentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property attacher so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert attacher()  {
    // check that actual VolumeAttachmentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAttacher()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attacher"));
  }


  /**
   * Navigates to the property nodeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert nodeName()  {
    // check that actual VolumeAttachmentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNodeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeName"));
  }


  /**
   * Navigates to the property source so that assertions can be done on it
   */
  public VolumeAttachmentSourceAssert source()  {
    // check that actual VolumeAttachmentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (VolumeAttachmentSourceAssert) assertThat(actual.getSource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "source"));
  }


}
