package io.fabric8.kubernetes.api.model.storage;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link VolumeAttachmentSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeAttachmentSourceAssert<S extends AbstractVolumeAttachmentSourceAssert<S, A>, A extends VolumeAttachmentSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeAttachmentSourceAssert}</code> to make assertions on actual VolumeAttachmentSource.
   * @param actual the VolumeAttachmentSource we want to make assertions on.
   */
  protected AbstractVolumeAttachmentSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual VolumeAttachmentSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property inlineVolumeSpec so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert inlineVolumeSpec()  {
    // check that actual VolumeAttachmentSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert) assertThat(actual.getInlineVolumeSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "inlineVolumeSpec"));
  }


  /**
   * Navigates to the property persistentVolumeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert persistentVolumeName()  {
    // check that actual VolumeAttachmentSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPersistentVolumeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeName"));
  }


}
