package io.fabric8.kubernetes.api.model.storage;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link VolumeAttachmentList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeAttachmentListAssert<S extends AbstractVolumeAttachmentListAssert<S, A>, A extends VolumeAttachmentList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeAttachmentListAssert}</code> to make assertions on actual VolumeAttachmentList.
   * @param actual the VolumeAttachmentList we want to make assertions on.
   */
  protected AbstractVolumeAttachmentListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual VolumeAttachmentList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual VolumeAttachmentList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<VolumeAttachment, VolumeAttachmentAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<VolumeAttachment, VolumeAttachmentAssert> assertFactory = new AssertFactory<VolumeAttachment, VolumeAttachmentAssert>() {
      public VolumeAttachmentAssert createAssert(VolumeAttachment t) {
        return (VolumeAttachmentAssert) assertThat(t);
      }
    };
    NavigationListAssert<VolumeAttachment, VolumeAttachmentAssert> answer = new NavigationListAssert<VolumeAttachment, VolumeAttachmentAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual VolumeAttachmentList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ListMetaAssert metadata()  {
    // check that actual VolumeAttachmentList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ListMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


}
