package io.fabric8.kubernetes.api.model.storage;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link StorageClass} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStorageClassAssert<S extends AbstractStorageClassAssert<S, A>, A extends StorageClass> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStorageClassAssert}</code> to make assertions on actual StorageClass.
   * @param actual the StorageClass we want to make assertions on.
   */
  protected AbstractStorageClassAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StorageClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allowVolumeExpansion so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowVolumeExpansion()  {
    // check that actual StorageClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowVolumeExpansion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowVolumeExpansion"));
  }


  /**
   * Navigates to the property allowedTopologies so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.TopologySelectorTerm, io.fabric8.kubernetes.api.model.TopologySelectorTermAssert> allowedTopologies()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.TopologySelectorTerm, io.fabric8.kubernetes.api.model.TopologySelectorTermAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.TopologySelectorTerm, io.fabric8.kubernetes.api.model.TopologySelectorTermAssert>() {
      public io.fabric8.kubernetes.api.model.TopologySelectorTermAssert createAssert(io.fabric8.kubernetes.api.model.TopologySelectorTerm t) {
        return (io.fabric8.kubernetes.api.model.TopologySelectorTermAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.TopologySelectorTerm, io.fabric8.kubernetes.api.model.TopologySelectorTermAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.TopologySelectorTerm, io.fabric8.kubernetes.api.model.TopologySelectorTermAssert>(actual.getAllowedTopologies(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedTopologies"));
    return answer;
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual StorageClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual StorageClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual StorageClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property mountOptions so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> mountOptions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getMountOptions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "mountOptions"));
    return answer;
  }


  /**
   * Navigates to the property parameters so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert parameters()  {
    // check that actual StorageClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getParameters()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "parameters"));
  }


  /**
   * Navigates to the property provisioner so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert provisioner()  {
    // check that actual StorageClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getProvisioner()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "provisioner"));
  }


  /**
   * Navigates to the property reclaimPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reclaimPolicy()  {
    // check that actual StorageClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReclaimPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reclaimPolicy"));
  }


  /**
   * Navigates to the property volumeBindingMode so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumeBindingMode()  {
    // check that actual StorageClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumeBindingMode()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeBindingMode"));
  }


}
