package io.fabric8.kubernetes.api.model.settings;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PodPresetSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodPresetSpecAssert<S extends AbstractPodPresetSpecAssert<S, A>, A extends PodPresetSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodPresetSpecAssert}</code> to make assertions on actual PodPresetSpec.
   * @param actual the PodPresetSpec we want to make assertions on.
   */
  protected AbstractPodPresetSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodPresetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property env so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> env()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>() {
      public io.fabric8.kubernetes.api.model.EnvVarAssert createAssert(io.fabric8.kubernetes.api.model.EnvVar t) {
        return (io.fabric8.kubernetes.api.model.EnvVarAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>(actual.getEnv(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "env"));
    return answer;
  }


  /**
   * Navigates to the property envFrom so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.EnvFromSource, io.fabric8.kubernetes.api.model.EnvFromSourceAssert> envFrom()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.EnvFromSource, io.fabric8.kubernetes.api.model.EnvFromSourceAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.EnvFromSource, io.fabric8.kubernetes.api.model.EnvFromSourceAssert>() {
      public io.fabric8.kubernetes.api.model.EnvFromSourceAssert createAssert(io.fabric8.kubernetes.api.model.EnvFromSource t) {
        return (io.fabric8.kubernetes.api.model.EnvFromSourceAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.EnvFromSource, io.fabric8.kubernetes.api.model.EnvFromSourceAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.EnvFromSource, io.fabric8.kubernetes.api.model.EnvFromSourceAssert>(actual.getEnvFrom(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "envFrom"));
    return answer;
  }


  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert selector()  {
    // check that actual PodPresetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property volumeMounts so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.VolumeMount, io.fabric8.kubernetes.api.model.VolumeMountAssert> volumeMounts()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.VolumeMount, io.fabric8.kubernetes.api.model.VolumeMountAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.VolumeMount, io.fabric8.kubernetes.api.model.VolumeMountAssert>() {
      public io.fabric8.kubernetes.api.model.VolumeMountAssert createAssert(io.fabric8.kubernetes.api.model.VolumeMount t) {
        return (io.fabric8.kubernetes.api.model.VolumeMountAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.VolumeMount, io.fabric8.kubernetes.api.model.VolumeMountAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.VolumeMount, io.fabric8.kubernetes.api.model.VolumeMountAssert>(actual.getVolumeMounts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeMounts"));
    return answer;
  }


  /**
   * Navigates to the property volumes so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.Volume, io.fabric8.kubernetes.api.model.VolumeAssert> volumes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.Volume, io.fabric8.kubernetes.api.model.VolumeAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.Volume, io.fabric8.kubernetes.api.model.VolumeAssert>() {
      public io.fabric8.kubernetes.api.model.VolumeAssert createAssert(io.fabric8.kubernetes.api.model.Volume t) {
        return (io.fabric8.kubernetes.api.model.VolumeAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.Volume, io.fabric8.kubernetes.api.model.VolumeAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.Volume, io.fabric8.kubernetes.api.model.VolumeAssert>(actual.getVolumes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumes"));
    return answer;
  }


}
