package io.fabric8.kubernetes.api.model.scheduling;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PriorityClass} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPriorityClassAssert<S extends AbstractPriorityClassAssert<S, A>, A extends PriorityClass> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPriorityClassAssert}</code> to make assertions on actual PriorityClass.
   * @param actual the PriorityClass we want to make assertions on.
   */
  protected AbstractPriorityClassAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PriorityClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual PriorityClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property description so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert description()  {
    // check that actual PriorityClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDescription()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "description"));
  }


  /**
   * Navigates to the property globalDefault so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert globalDefault()  {
    // check that actual PriorityClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getGlobalDefault()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "globalDefault"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual PriorityClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual PriorityClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property preemptionPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert preemptionPolicy()  {
    // check that actual PriorityClass we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPreemptionPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preemptionPolicy"));
  }


  /**
   * Verifies that the actual PriorityClass's value is equal to the given one.
   * @param value the given value to compare the actual PriorityClass's value to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PriorityClass's value is not equal to the given one.
   */
  public S hasValue(Integer value) {
    // check that actual PriorityClass we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualValue = actual.getValue();
    if (!Objects.areEqual(actualValue, value)) {
      failWithMessage(assertjErrorMessage, actual, value, actualValue);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
