package io.fabric8.kubernetes.api.model.runtime;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link RawExtension} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRawExtensionAssert<S extends AbstractRawExtensionAssert<S, A>, A extends RawExtension> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRawExtensionAssert}</code> to make assertions on actual RawExtension.
   * @param actual the RawExtension we want to make assertions on.
   */
  protected AbstractRawExtensionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RawExtension we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


}
