package io.fabric8.kubernetes.api.model.rbac;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link RoleBinding} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRoleBindingAssert<S extends AbstractRoleBindingAssert<S, A>, A extends RoleBinding> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRoleBindingAssert}</code> to make assertions on actual RoleBinding.
   * @param actual the RoleBinding we want to make assertions on.
   */
  protected AbstractRoleBindingAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property roleRef so that assertions can be done on it
   */
  public RoleRefAssert roleRef()  {
    // check that actual RoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RoleRefAssert) assertThat(actual.getRoleRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleRef"));
  }


  /**
   * Navigates to the property subjects so that assertions can be done on it
   */
  public NavigationListAssert<Subject, SubjectAssert> subjects()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Subject, SubjectAssert> assertFactory = new AssertFactory<Subject, SubjectAssert>() {
      public SubjectAssert createAssert(Subject t) {
        return (SubjectAssert) assertThat(t);
      }
    };
    NavigationListAssert<Subject, SubjectAssert> answer = new NavigationListAssert<Subject, SubjectAssert>(actual.getSubjects(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subjects"));
    return answer;
  }


}
