package io.fabric8.kubernetes.api.model.rbac;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link AggregationRule} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAggregationRuleAssert<S extends AbstractAggregationRuleAssert<S, A>, A extends AggregationRule> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAggregationRuleAssert}</code> to make assertions on actual AggregationRule.
   * @param actual the AggregationRule we want to make assertions on.
   */
  protected AbstractAggregationRuleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual AggregationRule we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property clusterRoleSelectors so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert> clusterRoleSelectors()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert>() {
      public io.fabric8.kubernetes.api.model.LabelSelectorAssert createAssert(io.fabric8.kubernetes.api.model.LabelSelector t) {
        return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert>(actual.getClusterRoleSelectors(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterRoleSelectors"));
    return answer;
  }


}
