package io.fabric8.kubernetes.api.model.policy;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link RuntimeClassStrategyOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRuntimeClassStrategyOptionsAssert<S extends AbstractRuntimeClassStrategyOptionsAssert<S, A>, A extends RuntimeClassStrategyOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRuntimeClassStrategyOptionsAssert}</code> to make assertions on actual RuntimeClassStrategyOptions.
   * @param actual the RuntimeClassStrategyOptions we want to make assertions on.
   */
  protected AbstractRuntimeClassStrategyOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RuntimeClassStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allowedRuntimeClassNames so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> allowedRuntimeClassNames()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAllowedRuntimeClassNames(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedRuntimeClassNames"));
    return answer;
  }


  /**
   * Navigates to the property defaultRuntimeClassName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert defaultRuntimeClassName()  {
    // check that actual RuntimeClassStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDefaultRuntimeClassName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "defaultRuntimeClassName"));
  }


}
