package io.fabric8.kubernetes.api.model.policy;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PodSecurityPolicySpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSecurityPolicySpecAssert<S extends AbstractPodSecurityPolicySpecAssert<S, A>, A extends PodSecurityPolicySpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSecurityPolicySpecAssert}</code> to make assertions on actual PodSecurityPolicySpec.
   * @param actual the PodSecurityPolicySpec we want to make assertions on.
   */
  protected AbstractPodSecurityPolicySpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allowPrivilegeEscalation so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowPrivilegeEscalation()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowPrivilegeEscalation()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowPrivilegeEscalation"));
  }


  /**
   * Navigates to the property allowedCSIDrivers so that assertions can be done on it
   */
  public NavigationListAssert<AllowedCSIDriver, AllowedCSIDriverAssert> allowedCSIDrivers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<AllowedCSIDriver, AllowedCSIDriverAssert> assertFactory = new AssertFactory<AllowedCSIDriver, AllowedCSIDriverAssert>() {
      public AllowedCSIDriverAssert createAssert(AllowedCSIDriver t) {
        return (AllowedCSIDriverAssert) assertThat(t);
      }
    };
    NavigationListAssert<AllowedCSIDriver, AllowedCSIDriverAssert> answer = new NavigationListAssert<AllowedCSIDriver, AllowedCSIDriverAssert>(actual.getAllowedCSIDrivers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedCSIDrivers"));
    return answer;
  }


  /**
   * Navigates to the property allowedCapabilities so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> allowedCapabilities()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAllowedCapabilities(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedCapabilities"));
    return answer;
  }


  /**
   * Navigates to the property allowedFlexVolumes so that assertions can be done on it
   */
  public NavigationListAssert<AllowedFlexVolume, AllowedFlexVolumeAssert> allowedFlexVolumes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<AllowedFlexVolume, AllowedFlexVolumeAssert> assertFactory = new AssertFactory<AllowedFlexVolume, AllowedFlexVolumeAssert>() {
      public AllowedFlexVolumeAssert createAssert(AllowedFlexVolume t) {
        return (AllowedFlexVolumeAssert) assertThat(t);
      }
    };
    NavigationListAssert<AllowedFlexVolume, AllowedFlexVolumeAssert> answer = new NavigationListAssert<AllowedFlexVolume, AllowedFlexVolumeAssert>(actual.getAllowedFlexVolumes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedFlexVolumes"));
    return answer;
  }


  /**
   * Navigates to the property allowedHostPaths so that assertions can be done on it
   */
  public NavigationListAssert<AllowedHostPath, AllowedHostPathAssert> allowedHostPaths()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<AllowedHostPath, AllowedHostPathAssert> assertFactory = new AssertFactory<AllowedHostPath, AllowedHostPathAssert>() {
      public AllowedHostPathAssert createAssert(AllowedHostPath t) {
        return (AllowedHostPathAssert) assertThat(t);
      }
    };
    NavigationListAssert<AllowedHostPath, AllowedHostPathAssert> answer = new NavigationListAssert<AllowedHostPath, AllowedHostPathAssert>(actual.getAllowedHostPaths(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedHostPaths"));
    return answer;
  }


  /**
   * Navigates to the property allowedProcMountTypes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> allowedProcMountTypes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAllowedProcMountTypes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedProcMountTypes"));
    return answer;
  }


  /**
   * Navigates to the property allowedUnsafeSysctls so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> allowedUnsafeSysctls()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAllowedUnsafeSysctls(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedUnsafeSysctls"));
    return answer;
  }


  /**
   * Navigates to the property defaultAddCapabilities so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> defaultAddCapabilities()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getDefaultAddCapabilities(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "defaultAddCapabilities"));
    return answer;
  }


  /**
   * Navigates to the property defaultAllowPrivilegeEscalation so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert defaultAllowPrivilegeEscalation()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getDefaultAllowPrivilegeEscalation()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "defaultAllowPrivilegeEscalation"));
  }


  /**
   * Navigates to the property forbiddenSysctls so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> forbiddenSysctls()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getForbiddenSysctls(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "forbiddenSysctls"));
    return answer;
  }


  /**
   * Navigates to the property fsGroup so that assertions can be done on it
   */
  public FSGroupStrategyOptionsAssert fsGroup()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FSGroupStrategyOptionsAssert) assertThat(actual.getFsGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsGroup"));
  }


  /**
   * Navigates to the property hostIPC so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert hostIPC()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getHostIPC()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostIPC"));
  }


  /**
   * Navigates to the property hostNetwork so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert hostNetwork()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getHostNetwork()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostNetwork"));
  }


  /**
   * Navigates to the property hostPID so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert hostPID()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getHostPID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostPID"));
  }


  /**
   * Navigates to the property hostPorts so that assertions can be done on it
   */
  public NavigationListAssert<HostPortRange, HostPortRangeAssert> hostPorts()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<HostPortRange, HostPortRangeAssert> assertFactory = new AssertFactory<HostPortRange, HostPortRangeAssert>() {
      public HostPortRangeAssert createAssert(HostPortRange t) {
        return (HostPortRangeAssert) assertThat(t);
      }
    };
    NavigationListAssert<HostPortRange, HostPortRangeAssert> answer = new NavigationListAssert<HostPortRange, HostPortRangeAssert>(actual.getHostPorts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostPorts"));
    return answer;
  }


  /**
   * Navigates to the property privileged so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert privileged()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getPrivileged()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "privileged"));
  }


  /**
   * Navigates to the property readOnlyRootFilesystem so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnlyRootFilesystem()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnlyRootFilesystem()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnlyRootFilesystem"));
  }


  /**
   * Navigates to the property requiredDropCapabilities so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> requiredDropCapabilities()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getRequiredDropCapabilities(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "requiredDropCapabilities"));
    return answer;
  }


  /**
   * Navigates to the property runAsGroup so that assertions can be done on it
   */
  public RunAsGroupStrategyOptionsAssert runAsGroup()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RunAsGroupStrategyOptionsAssert) assertThat(actual.getRunAsGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runAsGroup"));
  }


  /**
   * Navigates to the property runAsUser so that assertions can be done on it
   */
  public KubernetesRunAsUserStrategyOptionsAssert runAsUser()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (KubernetesRunAsUserStrategyOptionsAssert) assertThat(actual.getRunAsUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runAsUser"));
  }


  /**
   * Navigates to the property runtimeClass so that assertions can be done on it
   */
  public RuntimeClassStrategyOptionsAssert runtimeClass()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RuntimeClassStrategyOptionsAssert) assertThat(actual.getRuntimeClass()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runtimeClass"));
  }


  /**
   * Navigates to the property seLinux so that assertions can be done on it
   */
  public SELinuxStrategyOptionsAssert seLinux()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SELinuxStrategyOptionsAssert) assertThat(actual.getSeLinux()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "seLinux"));
  }


  /**
   * Navigates to the property supplementalGroups so that assertions can be done on it
   */
  public SupplementalGroupsStrategyOptionsAssert supplementalGroups()  {
    // check that actual PodSecurityPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SupplementalGroupsStrategyOptionsAssert) assertThat(actual.getSupplementalGroups()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "supplementalGroups"));
  }


  /**
   * Navigates to the property volumes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> volumes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getVolumes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumes"));
    return answer;
  }


}
