package io.fabric8.kubernetes.api.model.policy;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PodSecurityPolicy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSecurityPolicyAssert<S extends AbstractPodSecurityPolicyAssert<S, A>, A extends PodSecurityPolicy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSecurityPolicyAssert}</code> to make assertions on actual PodSecurityPolicy.
   * @param actual the PodSecurityPolicy we want to make assertions on.
   */
  protected AbstractPodSecurityPolicyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodSecurityPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual PodSecurityPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual PodSecurityPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual PodSecurityPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property spec so that assertions can be done on it
   */
  public PodSecurityPolicySpecAssert spec()  {
    // check that actual PodSecurityPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodSecurityPolicySpecAssert) assertThat(actual.getSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "spec"));
  }


}
