package io.fabric8.kubernetes.api.model.policy;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PodDisruptionBudgetStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodDisruptionBudgetStatusAssert<S extends AbstractPodDisruptionBudgetStatusAssert<S, A>, A extends PodDisruptionBudgetStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodDisruptionBudgetStatusAssert}</code> to make assertions on actual PodDisruptionBudgetStatus.
   * @param actual the PodDisruptionBudgetStatus we want to make assertions on.
   */
  protected AbstractPodDisruptionBudgetStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodDisruptionBudgetStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual PodDisruptionBudgetStatus's currentHealthy is equal to the given one.
   * @param currentHealthy the given currentHealthy to compare the actual PodDisruptionBudgetStatus's currentHealthy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodDisruptionBudgetStatus's currentHealthy is not equal to the given one.
   */
  public S hasCurrentHealthy(Integer currentHealthy) {
    // check that actual PodDisruptionBudgetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting currentHealthy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCurrentHealthy = actual.getCurrentHealthy();
    if (!Objects.areEqual(actualCurrentHealthy, currentHealthy)) {
      failWithMessage(assertjErrorMessage, actual, currentHealthy, actualCurrentHealthy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodDisruptionBudgetStatus's desiredHealthy is equal to the given one.
   * @param desiredHealthy the given desiredHealthy to compare the actual PodDisruptionBudgetStatus's desiredHealthy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodDisruptionBudgetStatus's desiredHealthy is not equal to the given one.
   */
  public S hasDesiredHealthy(Integer desiredHealthy) {
    // check that actual PodDisruptionBudgetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting desiredHealthy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualDesiredHealthy = actual.getDesiredHealthy();
    if (!Objects.areEqual(actualDesiredHealthy, desiredHealthy)) {
      failWithMessage(assertjErrorMessage, actual, desiredHealthy, actualDesiredHealthy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property disruptedPods so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert disruptedPods()  {
    // check that actual PodDisruptionBudgetStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getDisruptedPods()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "disruptedPods"));
  }


  /**
   * Verifies that the actual PodDisruptionBudgetStatus's disruptionsAllowed is equal to the given one.
   * @param disruptionsAllowed the given disruptionsAllowed to compare the actual PodDisruptionBudgetStatus's disruptionsAllowed to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodDisruptionBudgetStatus's disruptionsAllowed is not equal to the given one.
   */
  public S hasDisruptionsAllowed(Integer disruptionsAllowed) {
    // check that actual PodDisruptionBudgetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting disruptionsAllowed of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualDisruptionsAllowed = actual.getDisruptionsAllowed();
    if (!Objects.areEqual(actualDisruptionsAllowed, disruptionsAllowed)) {
      failWithMessage(assertjErrorMessage, actual, disruptionsAllowed, actualDisruptionsAllowed);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodDisruptionBudgetStatus's expectedPods is equal to the given one.
   * @param expectedPods the given expectedPods to compare the actual PodDisruptionBudgetStatus's expectedPods to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodDisruptionBudgetStatus's expectedPods is not equal to the given one.
   */
  public S hasExpectedPods(Integer expectedPods) {
    // check that actual PodDisruptionBudgetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting expectedPods of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualExpectedPods = actual.getExpectedPods();
    if (!Objects.areEqual(actualExpectedPods, expectedPods)) {
      failWithMessage(assertjErrorMessage, actual, expectedPods, actualExpectedPods);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodDisruptionBudgetStatus's observedGeneration is equal to the given one.
   * @param observedGeneration the given observedGeneration to compare the actual PodDisruptionBudgetStatus's observedGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodDisruptionBudgetStatus's observedGeneration is not equal to the given one.
   */
  public S hasObservedGeneration(Long observedGeneration) {
    // check that actual PodDisruptionBudgetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualObservedGeneration = actual.getObservedGeneration();
    if (!Objects.areEqual(actualObservedGeneration, observedGeneration)) {
      failWithMessage(assertjErrorMessage, actual, observedGeneration, actualObservedGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
