package io.fabric8.kubernetes.api.model.policy;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link AllowedHostPath} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAllowedHostPathAssert<S extends AbstractAllowedHostPathAssert<S, A>, A extends AllowedHostPath> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAllowedHostPathAssert}</code> to make assertions on actual AllowedHostPath.
   * @param actual the AllowedHostPath we want to make assertions on.
   */
  protected AbstractAllowedHostPathAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual AllowedHostPath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property pathPrefix so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert pathPrefix()  {
    // check that actual AllowedHostPath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPathPrefix()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pathPrefix"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual AllowedHostPath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


}
