package io.fabric8.kubernetes.api.model.policy;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link AllowedCSIDriver} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAllowedCSIDriverAssert<S extends AbstractAllowedCSIDriverAssert<S, A>, A extends AllowedCSIDriver> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAllowedCSIDriverAssert}</code> to make assertions on actual AllowedCSIDriver.
   * @param actual the AllowedCSIDriver we want to make assertions on.
   */
  protected AbstractAllowedCSIDriverAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual AllowedCSIDriver we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual AllowedCSIDriver we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


}
