package io.fabric8.kubernetes.api.model.networking;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NetworkPolicyPort} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNetworkPolicyPortAssert<S extends AbstractNetworkPolicyPortAssert<S, A>, A extends NetworkPolicyPort> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNetworkPolicyPortAssert}</code> to make assertions on actual NetworkPolicyPort.
   * @param actual the NetworkPolicyPort we want to make assertions on.
   */
  protected AbstractNetworkPolicyPortAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NetworkPolicyPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property port so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.IntOrStringAssert port()  {
    // check that actual NetworkPolicyPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.IntOrStringAssert) assertThat(actual.getPort()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "port"));
  }


  /**
   * Navigates to the property protocol so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert protocol()  {
    // check that actual NetworkPolicyPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getProtocol()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "protocol"));
  }


}
