package io.fabric8.kubernetes.api.model.networking;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NetworkPolicyPeer} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNetworkPolicyPeerAssert<S extends AbstractNetworkPolicyPeerAssert<S, A>, A extends NetworkPolicyPeer> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNetworkPolicyPeerAssert}</code> to make assertions on actual NetworkPolicyPeer.
   * @param actual the NetworkPolicyPeer we want to make assertions on.
   */
  protected AbstractNetworkPolicyPeerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NetworkPolicyPeer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property ipBlock so that assertions can be done on it
   */
  public IPBlockAssert ipBlock()  {
    // check that actual NetworkPolicyPeer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (IPBlockAssert) assertThat(actual.getIpBlock()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ipBlock"));
  }


  /**
   * Navigates to the property namespaceSelector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert namespaceSelector()  {
    // check that actual NetworkPolicyPeer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getNamespaceSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespaceSelector"));
  }


  /**
   * Navigates to the property podSelector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert podSelector()  {
    // check that actual NetworkPolicyPeer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getPodSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podSelector"));
  }


}
