package io.fabric8.kubernetes.api.model.networking;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NetworkPolicyEgressRule} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNetworkPolicyEgressRuleAssert<S extends AbstractNetworkPolicyEgressRuleAssert<S, A>, A extends NetworkPolicyEgressRule> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNetworkPolicyEgressRuleAssert}</code> to make assertions on actual NetworkPolicyEgressRule.
   * @param actual the NetworkPolicyEgressRule we want to make assertions on.
   */
  protected AbstractNetworkPolicyEgressRuleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NetworkPolicyEgressRule we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property ports so that assertions can be done on it
   */
  public NavigationListAssert<NetworkPolicyPort, NetworkPolicyPortAssert> ports()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NetworkPolicyPort, NetworkPolicyPortAssert> assertFactory = new AssertFactory<NetworkPolicyPort, NetworkPolicyPortAssert>() {
      public NetworkPolicyPortAssert createAssert(NetworkPolicyPort t) {
        return (NetworkPolicyPortAssert) assertThat(t);
      }
    };
    NavigationListAssert<NetworkPolicyPort, NetworkPolicyPortAssert> answer = new NavigationListAssert<NetworkPolicyPort, NetworkPolicyPortAssert>(actual.getPorts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ports"));
    return answer;
  }


  /**
   * Navigates to the property to so that assertions can be done on it
   */
  public NavigationListAssert<NetworkPolicyPeer, NetworkPolicyPeerAssert> to()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NetworkPolicyPeer, NetworkPolicyPeerAssert> assertFactory = new AssertFactory<NetworkPolicyPeer, NetworkPolicyPeerAssert>() {
      public NetworkPolicyPeerAssert createAssert(NetworkPolicyPeer t) {
        return (NetworkPolicyPeerAssert) assertThat(t);
      }
    };
    NavigationListAssert<NetworkPolicyPeer, NetworkPolicyPeerAssert> answer = new NavigationListAssert<NetworkPolicyPeer, NetworkPolicyPeerAssert>(actual.getTo(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "to"));
    return answer;
  }


}
