package io.fabric8.kubernetes.api.model.networking;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link IPBlock} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIPBlockAssert<S extends AbstractIPBlockAssert<S, A>, A extends IPBlock> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIPBlockAssert}</code> to make assertions on actual IPBlock.
   * @param actual the IPBlock we want to make assertions on.
   */
  protected AbstractIPBlockAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual IPBlock we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property cidr so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert cidr()  {
    // check that actual IPBlock we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCidr()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cidr"));
  }


  /**
   * Navigates to the property except so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> except()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getExcept(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "except"));
    return answer;
  }


}
