package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link PodMetrics} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodMetricsAssert<S extends AbstractPodMetricsAssert<S, A>, A extends PodMetrics> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodMetricsAssert}</code> to make assertions on actual PodMetrics.
   * @param actual the PodMetrics we want to make assertions on.
   */
  protected AbstractPodMetricsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodMetrics we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual PodMetrics we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property containers so that assertions can be done on it
   */
  public NavigationListAssert<ContainerMetrics, ContainerMetricsAssert> containers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ContainerMetrics, ContainerMetricsAssert> assertFactory = new AssertFactory<ContainerMetrics, ContainerMetricsAssert>() {
      public ContainerMetricsAssert createAssert(ContainerMetrics t) {
        return (ContainerMetricsAssert) assertThat(t);
      }
    };
    NavigationListAssert<ContainerMetrics, ContainerMetricsAssert> answer = new NavigationListAssert<ContainerMetrics, ContainerMetricsAssert>(actual.getContainers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containers"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual PodMetrics we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual PodMetrics we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property timestamp so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert timestamp()  {
    // check that actual PodMetrics we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "timestamp"));
  }


  /**
   * Navigates to the property window so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.DurationAssert window()  {
    // check that actual PodMetrics we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.DurationAssert) assertThat(actual.getWindow()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "window"));
  }


}
