package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ContainerMetrics} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerMetricsAssert<S extends AbstractContainerMetricsAssert<S, A>, A extends ContainerMetrics> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerMetricsAssert}</code> to make assertions on actual ContainerMetrics.
   * @param actual the ContainerMetrics we want to make assertions on.
   */
  protected AbstractContainerMetricsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ContainerMetrics we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual ContainerMetrics we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property usage so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert usage()  {
    // check that actual ContainerMetrics we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getUsage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "usage"));
  }


}
