package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link RollbackConfig} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRollbackConfigAssert<S extends AbstractRollbackConfigAssert<S, A>, A extends RollbackConfig> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRollbackConfigAssert}</code> to make assertions on actual RollbackConfig.
   * @param actual the RollbackConfig we want to make assertions on.
   */
  protected AbstractRollbackConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RollbackConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual RollbackConfig's revision is equal to the given one.
   * @param revision the given revision to compare the actual RollbackConfig's revision to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollbackConfig's revision is not equal to the given one.
   */
  public S hasRevision(Long revision) {
    // check that actual RollbackConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting revision of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRevision = actual.getRevision();
    if (!Objects.areEqual(actualRevision, revision)) {
      failWithMessage(assertjErrorMessage, actual, revision, actualRevision);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
