package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link IngressTLS} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressTLSAssert<S extends AbstractIngressTLSAssert<S, A>, A extends IngressTLS> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressTLSAssert}</code> to make assertions on actual IngressTLS.
   * @param actual the IngressTLS we want to make assertions on.
   */
  protected AbstractIngressTLSAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual IngressTLS we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property hosts so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> hosts()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getHosts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hosts"));
    return answer;
  }


  /**
   * Navigates to the property secretName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert secretName()  {
    // check that actual IngressTLS we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSecretName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretName"));
  }


}
