package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link HTTPIngressPath} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHTTPIngressPathAssert<S extends AbstractHTTPIngressPathAssert<S, A>, A extends HTTPIngressPath> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHTTPIngressPathAssert}</code> to make assertions on actual HTTPIngressPath.
   * @param actual the HTTPIngressPath we want to make assertions on.
   */
  protected AbstractHTTPIngressPathAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual HTTPIngressPath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property backend so that assertions can be done on it
   */
  public IngressBackendAssert backend()  {
    // check that actual HTTPIngressPath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (IngressBackendAssert) assertThat(actual.getBackend()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "backend"));
  }


  /**
   * Navigates to the property path so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert path()  {
    // check that actual HTTPIngressPath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "path"));
  }


}
