package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentRollback} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentRollbackAssert<S extends AbstractDeploymentRollbackAssert<S, A>, A extends DeploymentRollback> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentRollbackAssert}</code> to make assertions on actual DeploymentRollback.
   * @param actual the DeploymentRollback we want to make assertions on.
   */
  protected AbstractDeploymentRollbackAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentRollback we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual DeploymentRollback we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual DeploymentRollback we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual DeploymentRollback we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property rollbackTo so that assertions can be done on it
   */
  public RollbackConfigAssert rollbackTo()  {
    // check that actual DeploymentRollback we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RollbackConfigAssert) assertThat(actual.getRollbackTo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rollbackTo"));
  }


  /**
   * Navigates to the property updatedAnnotations so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert updatedAnnotations()  {
    // check that actual DeploymentRollback we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getUpdatedAnnotations()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "updatedAnnotations"));
  }


}
