package io.fabric8.kubernetes.api.model.events;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link EventSeries} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEventSeriesAssert<S extends AbstractEventSeriesAssert<S, A>, A extends EventSeries> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEventSeriesAssert}</code> to make assertions on actual EventSeries.
   * @param actual the EventSeries we want to make assertions on.
   */
  protected AbstractEventSeriesAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual EventSeries we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual EventSeries's count is equal to the given one.
   * @param count the given count to compare the actual EventSeries's count to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EventSeries's count is not equal to the given one.
   */
  public S hasCount(Integer count) {
    // check that actual EventSeries we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting count of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCount = actual.getCount();
    if (!Objects.areEqual(actualCount, count)) {
      failWithMessage(assertjErrorMessage, actual, count, actualCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property lastObservedTime so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.MicroTimeAssert lastObservedTime()  {
    // check that actual EventSeries we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.MicroTimeAssert) assertThat(actual.getLastObservedTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastObservedTime"));
  }


  /**
   * Navigates to the property state so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert state()  {
    // check that actual EventSeries we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getState()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "state"));
  }


}
