package io.fabric8.kubernetes.api.model.events;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Event} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEventAssert<S extends AbstractEventAssert<S, A>, A extends Event> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEventAssert}</code> to make assertions on actual Event.
   * @param actual the Event we want to make assertions on.
   */
  protected AbstractEventAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property action so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert action()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAction()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "action"));
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Verifies that the actual Event's deprecatedCount is equal to the given one.
   * @param deprecatedCount the given deprecatedCount to compare the actual Event's deprecatedCount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's deprecatedCount is not equal to the given one.
   */
  public S hasDeprecatedCount(Integer deprecatedCount) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deprecatedCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualDeprecatedCount = actual.getDeprecatedCount();
    if (!Objects.areEqual(actualDeprecatedCount, deprecatedCount)) {
      failWithMessage(assertjErrorMessage, actual, deprecatedCount, actualDeprecatedCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property deprecatedFirstTimestamp so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert deprecatedFirstTimestamp()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDeprecatedFirstTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deprecatedFirstTimestamp"));
  }


  /**
   * Navigates to the property deprecatedLastTimestamp so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert deprecatedLastTimestamp()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDeprecatedLastTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deprecatedLastTimestamp"));
  }


  /**
   * Navigates to the property deprecatedSource so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.EventSourceAssert deprecatedSource()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.EventSourceAssert) assertThat(actual.getDeprecatedSource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deprecatedSource"));
  }


  /**
   * Navigates to the property eventTime so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.MicroTimeAssert eventTime()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.MicroTimeAssert) assertThat(actual.getEventTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "eventTime"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property note so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert note()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNote()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "note"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Navigates to the property regarding so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert regarding()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getRegarding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "regarding"));
  }


  /**
   * Navigates to the property related so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert related()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getRelated()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "related"));
  }


  /**
   * Navigates to the property reportingController so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reportingController()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReportingController()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reportingController"));
  }


  /**
   * Navigates to the property reportingInstance so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reportingInstance()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReportingInstance()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reportingInstance"));
  }


  /**
   * Navigates to the property series so that assertions can be done on it
   */
  public EventSeriesAssert series()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EventSeriesAssert) assertThat(actual.getSeries()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "series"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
