package io.fabric8.kubernetes.api.model.discovery;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link EndpointSlice} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointSliceAssert<S extends AbstractEndpointSliceAssert<S, A>, A extends EndpointSlice> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointSliceAssert}</code> to make assertions on actual EndpointSlice.
   * @param actual the EndpointSlice we want to make assertions on.
   */
  protected AbstractEndpointSliceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual EndpointSlice we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property addressType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert addressType()  {
    // check that actual EndpointSlice we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAddressType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "addressType"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual EndpointSlice we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property endpoints so that assertions can be done on it
   */
  public NavigationListAssert<Endpoint, EndpointAssert> endpoints()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Endpoint, EndpointAssert> assertFactory = new AssertFactory<Endpoint, EndpointAssert>() {
      public EndpointAssert createAssert(Endpoint t) {
        return (EndpointAssert) assertThat(t);
      }
    };
    NavigationListAssert<Endpoint, EndpointAssert> answer = new NavigationListAssert<Endpoint, EndpointAssert>(actual.getEndpoints(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpoints"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual EndpointSlice we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual EndpointSlice we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property ports so that assertions can be done on it
   */
  public NavigationListAssert<DiscoveryEndpointPort, DiscoveryEndpointPortAssert> ports()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<DiscoveryEndpointPort, DiscoveryEndpointPortAssert> assertFactory = new AssertFactory<DiscoveryEndpointPort, DiscoveryEndpointPortAssert>() {
      public DiscoveryEndpointPortAssert createAssert(DiscoveryEndpointPort t) {
        return (DiscoveryEndpointPortAssert) assertThat(t);
      }
    };
    NavigationListAssert<DiscoveryEndpointPort, DiscoveryEndpointPortAssert> answer = new NavigationListAssert<DiscoveryEndpointPort, DiscoveryEndpointPortAssert>(actual.getPorts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ports"));
    return answer;
  }


}
