package io.fabric8.kubernetes.api.model.discovery;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link Endpoint} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointAssert<S extends AbstractEndpointAssert<S, A>, A extends Endpoint> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointAssert}</code> to make assertions on actual Endpoint.
   * @param actual the Endpoint we want to make assertions on.
   */
  protected AbstractEndpointAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Endpoint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property addresses so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> addresses()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAddresses(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "addresses"));
    return answer;
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public EndpointConditionsAssert conditions()  {
    // check that actual Endpoint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EndpointConditionsAssert) assertThat(actual.getConditions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
  }


  /**
   * Navigates to the property hostname so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert hostname()  {
    // check that actual Endpoint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHostname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostname"));
  }


  /**
   * Navigates to the property targetRef so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert targetRef()  {
    // check that actual Endpoint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getTargetRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "targetRef"));
  }


  /**
   * Navigates to the property topology so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert topology()  {
    // check that actual Endpoint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getTopology()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "topology"));
  }


}
