package io.fabric8.kubernetes.api.model.discovery;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link DiscoveryEndpointPort} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDiscoveryEndpointPortAssert<S extends AbstractDiscoveryEndpointPortAssert<S, A>, A extends DiscoveryEndpointPort> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDiscoveryEndpointPortAssert}</code> to make assertions on actual DiscoveryEndpointPort.
   * @param actual the DiscoveryEndpointPort we want to make assertions on.
   */
  protected AbstractDiscoveryEndpointPortAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DiscoveryEndpointPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property appProtocol so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert appProtocol()  {
    // check that actual DiscoveryEndpointPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAppProtocol()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "appProtocol"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual DiscoveryEndpointPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Verifies that the actual DiscoveryEndpointPort's port is equal to the given one.
   * @param port the given port to compare the actual DiscoveryEndpointPort's port to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DiscoveryEndpointPort's port is not equal to the given one.
   */
  public S hasPort(Integer port) {
    // check that actual DiscoveryEndpointPort we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPort = actual.getPort();
    if (!Objects.areEqual(actualPort, port)) {
      failWithMessage(assertjErrorMessage, actual, port, actualPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property protocol so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert protocol()  {
    // check that actual DiscoveryEndpointPort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getProtocol()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "protocol"));
  }


}
