package io.fabric8.kubernetes.api.model.coordination.v1;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link LeaseSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLeaseSpecAssert<S extends AbstractLeaseSpecAssert<S, A>, A extends LeaseSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLeaseSpecAssert}</code> to make assertions on actual LeaseSpec.
   * @param actual the LeaseSpec we want to make assertions on.
   */
  protected AbstractLeaseSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property acquireTime so that assertions can be done on it
   */
  public org.assertj.core.api.ZonedDateTimeAssert acquireTime()  {
    // check that actual LeaseSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.ZonedDateTimeAssert) assertThat(actual.getAcquireTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "acquireTime"));
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual LeaseSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property holderIdentity so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert holderIdentity()  {
    // check that actual LeaseSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHolderIdentity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "holderIdentity"));
  }


  /**
   * Verifies that the actual LeaseSpec's leaseDurationSeconds is equal to the given one.
   * @param leaseDurationSeconds the given leaseDurationSeconds to compare the actual LeaseSpec's leaseDurationSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LeaseSpec's leaseDurationSeconds is not equal to the given one.
   */
  public S hasLeaseDurationSeconds(Integer leaseDurationSeconds) {
    // check that actual LeaseSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting leaseDurationSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLeaseDurationSeconds = actual.getLeaseDurationSeconds();
    if (!Objects.areEqual(actualLeaseDurationSeconds, leaseDurationSeconds)) {
      failWithMessage(assertjErrorMessage, actual, leaseDurationSeconds, actualLeaseDurationSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LeaseSpec's leaseTransitions is equal to the given one.
   * @param leaseTransitions the given leaseTransitions to compare the actual LeaseSpec's leaseTransitions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LeaseSpec's leaseTransitions is not equal to the given one.
   */
  public S hasLeaseTransitions(Integer leaseTransitions) {
    // check that actual LeaseSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting leaseTransitions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLeaseTransitions = actual.getLeaseTransitions();
    if (!Objects.areEqual(actualLeaseTransitions, leaseTransitions)) {
      failWithMessage(assertjErrorMessage, actual, leaseTransitions, actualLeaseTransitions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property renewTime so that assertions can be done on it
   */
  public org.assertj.core.api.ZonedDateTimeAssert renewTime()  {
    // check that actual LeaseSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.ZonedDateTimeAssert) assertThat(actual.getRenewTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "renewTime"));
  }


}
