package io.fabric8.kubernetes.api.model.certificates;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CertificateSigningRequestStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCertificateSigningRequestStatusAssert<S extends AbstractCertificateSigningRequestStatusAssert<S, A>, A extends CertificateSigningRequestStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCertificateSigningRequestStatusAssert}</code> to make assertions on actual CertificateSigningRequestStatus.
   * @param actual the CertificateSigningRequestStatus we want to make assertions on.
   */
  protected AbstractCertificateSigningRequestStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CertificateSigningRequestStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property certificate so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert certificate()  {
    // check that actual CertificateSigningRequestStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCertificate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificate"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<CertificateSigningRequestCondition, CertificateSigningRequestConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<CertificateSigningRequestCondition, CertificateSigningRequestConditionAssert> assertFactory = new AssertFactory<CertificateSigningRequestCondition, CertificateSigningRequestConditionAssert>() {
      public CertificateSigningRequestConditionAssert createAssert(CertificateSigningRequestCondition t) {
        return (CertificateSigningRequestConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<CertificateSigningRequestCondition, CertificateSigningRequestConditionAssert> answer = new NavigationListAssert<CertificateSigningRequestCondition, CertificateSigningRequestConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


}
