package io.fabric8.kubernetes.api.model.certificates;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CertificateSigningRequestSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCertificateSigningRequestSpecAssert<S extends AbstractCertificateSigningRequestSpecAssert<S, A>, A extends CertificateSigningRequestSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCertificateSigningRequestSpecAssert}</code> to make assertions on actual CertificateSigningRequestSpec.
   * @param actual the CertificateSigningRequestSpec we want to make assertions on.
   */
  protected AbstractCertificateSigningRequestSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CertificateSigningRequestSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property extra so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert extra()  {
    // check that actual CertificateSigningRequestSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getExtra()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extra"));
  }


  /**
   * Navigates to the property groups so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> groups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groups"));
    return answer;
  }


  /**
   * Navigates to the property request so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert request()  {
    // check that actual CertificateSigningRequestSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRequest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "request"));
  }


  /**
   * Navigates to the property uid so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uid()  {
    // check that actual CertificateSigningRequestSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"));
  }


  /**
   * Navigates to the property usages so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> usages()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getUsages(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "usages"));
    return answer;
  }


  /**
   * Navigates to the property username so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert username()  {
    // check that actual CertificateSigningRequestSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUsername()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "username"));
  }


}
