package io.fabric8.kubernetes.api.model.batch;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link JobStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJobStatusAssert<S extends AbstractJobStatusAssert<S, A>, A extends JobStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJobStatusAssert}</code> to make assertions on actual JobStatus.
   * @param actual the JobStatus we want to make assertions on.
   */
  protected AbstractJobStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Verifies that the actual JobStatus's active is equal to the given one.
   * @param active the given active to compare the actual JobStatus's active to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobStatus's active is not equal to the given one.
   */
  public S hasActive(Integer active) {
    // check that actual JobStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting active of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualActive = actual.getActive();
    if (!Objects.areEqual(actualActive, active)) {
      failWithMessage(assertjErrorMessage, actual, active, actualActive);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual JobStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property completionTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert completionTime()  {
    // check that actual JobStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCompletionTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "completionTime"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<JobCondition, JobConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<JobCondition, JobConditionAssert> assertFactory = new AssertFactory<JobCondition, JobConditionAssert>() {
      public JobConditionAssert createAssert(JobCondition t) {
        return (JobConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<JobCondition, JobConditionAssert> answer = new NavigationListAssert<JobCondition, JobConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Verifies that the actual JobStatus's failed is equal to the given one.
   * @param failed the given failed to compare the actual JobStatus's failed to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobStatus's failed is not equal to the given one.
   */
  public S hasFailed(Integer failed) {
    // check that actual JobStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting failed of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualFailed = actual.getFailed();
    if (!Objects.areEqual(actualFailed, failed)) {
      failWithMessage(assertjErrorMessage, actual, failed, actualFailed);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property startTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert startTime()  {
    // check that actual JobStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStartTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startTime"));
  }


  /**
   * Verifies that the actual JobStatus's succeeded is equal to the given one.
   * @param succeeded the given succeeded to compare the actual JobStatus's succeeded to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobStatus's succeeded is not equal to the given one.
   */
  public S hasSucceeded(Integer succeeded) {
    // check that actual JobStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting succeeded of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualSucceeded = actual.getSucceeded();
    if (!Objects.areEqual(actualSucceeded, succeeded)) {
      failWithMessage(assertjErrorMessage, actual, succeeded, actualSucceeded);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
