package io.fabric8.kubernetes.api.model.batch;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link CronJobSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCronJobSpecAssert<S extends AbstractCronJobSpecAssert<S, A>, A extends CronJobSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCronJobSpecAssert}</code> to make assertions on actual CronJobSpec.
   * @param actual the CronJobSpec we want to make assertions on.
   */
  protected AbstractCronJobSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CronJobSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property concurrencyPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert concurrencyPolicy()  {
    // check that actual CronJobSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getConcurrencyPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "concurrencyPolicy"));
  }


  /**
   * Verifies that the actual CronJobSpec's failedJobsHistoryLimit is equal to the given one.
   * @param failedJobsHistoryLimit the given failedJobsHistoryLimit to compare the actual CronJobSpec's failedJobsHistoryLimit to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CronJobSpec's failedJobsHistoryLimit is not equal to the given one.
   */
  public S hasFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
    // check that actual CronJobSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting failedJobsHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualFailedJobsHistoryLimit = actual.getFailedJobsHistoryLimit();
    if (!Objects.areEqual(actualFailedJobsHistoryLimit, failedJobsHistoryLimit)) {
      failWithMessage(assertjErrorMessage, actual, failedJobsHistoryLimit, actualFailedJobsHistoryLimit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property jobTemplate so that assertions can be done on it
   */
  public JobTemplateSpecAssert jobTemplate()  {
    // check that actual CronJobSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (JobTemplateSpecAssert) assertThat(actual.getJobTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "jobTemplate"));
  }


  /**
   * Navigates to the property schedule so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert schedule()  {
    // check that actual CronJobSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSchedule()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "schedule"));
  }


  /**
   * Verifies that the actual CronJobSpec's startingDeadlineSeconds is equal to the given one.
   * @param startingDeadlineSeconds the given startingDeadlineSeconds to compare the actual CronJobSpec's startingDeadlineSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CronJobSpec's startingDeadlineSeconds is not equal to the given one.
   */
  public S hasStartingDeadlineSeconds(Long startingDeadlineSeconds) {
    // check that actual CronJobSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting startingDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualStartingDeadlineSeconds = actual.getStartingDeadlineSeconds();
    if (!Objects.areEqual(actualStartingDeadlineSeconds, startingDeadlineSeconds)) {
      failWithMessage(assertjErrorMessage, actual, startingDeadlineSeconds, actualStartingDeadlineSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CronJobSpec's successfulJobsHistoryLimit is equal to the given one.
   * @param successfulJobsHistoryLimit the given successfulJobsHistoryLimit to compare the actual CronJobSpec's successfulJobsHistoryLimit to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CronJobSpec's successfulJobsHistoryLimit is not equal to the given one.
   */
  public S hasSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
    // check that actual CronJobSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting successfulJobsHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualSuccessfulJobsHistoryLimit = actual.getSuccessfulJobsHistoryLimit();
    if (!Objects.areEqual(actualSuccessfulJobsHistoryLimit, successfulJobsHistoryLimit)) {
      failWithMessage(assertjErrorMessage, actual, successfulJobsHistoryLimit, actualSuccessfulJobsHistoryLimit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property suspend so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert suspend()  {
    // check that actual CronJobSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getSuspend()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "suspend"));
  }


}
