package io.fabric8.kubernetes.api.model.authorization;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SubjectRulesReviewStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSubjectRulesReviewStatusAssert<S extends AbstractSubjectRulesReviewStatusAssert<S, A>, A extends SubjectRulesReviewStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSubjectRulesReviewStatusAssert}</code> to make assertions on actual SubjectRulesReviewStatus.
   * @param actual the SubjectRulesReviewStatus we want to make assertions on.
   */
  protected AbstractSubjectRulesReviewStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SubjectRulesReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property evaluationError so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert evaluationError()  {
    // check that actual SubjectRulesReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getEvaluationError()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "evaluationError"));
  }


  /**
   * Navigates to the property incomplete so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert incomplete()  {
    // check that actual SubjectRulesReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getIncomplete()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "incomplete"));
  }


  /**
   * Navigates to the property nonResourceRules so that assertions can be done on it
   */
  public NavigationListAssert<NonResourceRule, NonResourceRuleAssert> nonResourceRules()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NonResourceRule, NonResourceRuleAssert> assertFactory = new AssertFactory<NonResourceRule, NonResourceRuleAssert>() {
      public NonResourceRuleAssert createAssert(NonResourceRule t) {
        return (NonResourceRuleAssert) assertThat(t);
      }
    };
    NavigationListAssert<NonResourceRule, NonResourceRuleAssert> answer = new NavigationListAssert<NonResourceRule, NonResourceRuleAssert>(actual.getNonResourceRules(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nonResourceRules"));
    return answer;
  }


  /**
   * Navigates to the property resourceRules so that assertions can be done on it
   */
  public NavigationListAssert<ResourceRule, ResourceRuleAssert> resourceRules()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ResourceRule, ResourceRuleAssert> assertFactory = new AssertFactory<ResourceRule, ResourceRuleAssert>() {
      public ResourceRuleAssert createAssert(ResourceRule t) {
        return (ResourceRuleAssert) assertThat(t);
      }
    };
    NavigationListAssert<ResourceRule, ResourceRuleAssert> answer = new NavigationListAssert<ResourceRule, ResourceRuleAssert>(actual.getResourceRules(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceRules"));
    return answer;
  }


}
