package io.fabric8.kubernetes.api.model.authorization;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SubjectAccessReviewStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSubjectAccessReviewStatusAssert<S extends AbstractSubjectAccessReviewStatusAssert<S, A>, A extends SubjectAccessReviewStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSubjectAccessReviewStatusAssert}</code> to make assertions on actual SubjectAccessReviewStatus.
   * @param actual the SubjectAccessReviewStatus we want to make assertions on.
   */
  protected AbstractSubjectAccessReviewStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SubjectAccessReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allowed so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowed()  {
    // check that actual SubjectAccessReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowed()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowed"));
  }


  /**
   * Navigates to the property denied so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert denied()  {
    // check that actual SubjectAccessReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getDenied()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "denied"));
  }


  /**
   * Navigates to the property evaluationError so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert evaluationError()  {
    // check that actual SubjectAccessReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getEvaluationError()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "evaluationError"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual SubjectAccessReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


}
