package io.fabric8.kubernetes.api.model.authorization;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SubjectAccessReviewSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSubjectAccessReviewSpecAssert<S extends AbstractSubjectAccessReviewSpecAssert<S, A>, A extends SubjectAccessReviewSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSubjectAccessReviewSpecAssert}</code> to make assertions on actual SubjectAccessReviewSpec.
   * @param actual the SubjectAccessReviewSpec we want to make assertions on.
   */
  protected AbstractSubjectAccessReviewSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SubjectAccessReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property extra so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert extra()  {
    // check that actual SubjectAccessReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getExtra()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extra"));
  }


  /**
   * Navigates to the property groups so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> groups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groups"));
    return answer;
  }


  /**
   * Navigates to the property nonResourceAttributes so that assertions can be done on it
   */
  public NonResourceAttributesAssert nonResourceAttributes()  {
    // check that actual SubjectAccessReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NonResourceAttributesAssert) assertThat(actual.getNonResourceAttributes()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nonResourceAttributes"));
  }


  /**
   * Navigates to the property resourceAttributes so that assertions can be done on it
   */
  public ResourceAttributesAssert resourceAttributes()  {
    // check that actual SubjectAccessReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceAttributesAssert) assertThat(actual.getResourceAttributes()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceAttributes"));
  }


  /**
   * Navigates to the property uid so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uid()  {
    // check that actual SubjectAccessReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert user()  {
    // check that actual SubjectAccessReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


}
