package io.fabric8.kubernetes.api.model.authorization;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SelfSubjectRulesReviewSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSelfSubjectRulesReviewSpecAssert<S extends AbstractSelfSubjectRulesReviewSpecAssert<S, A>, A extends SelfSubjectRulesReviewSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSelfSubjectRulesReviewSpecAssert}</code> to make assertions on actual SelfSubjectRulesReviewSpec.
   * @param actual the SelfSubjectRulesReviewSpec we want to make assertions on.
   */
  protected AbstractSelfSubjectRulesReviewSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SelfSubjectRulesReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert namespace()  {
    // check that actual SelfSubjectRulesReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


}
