package io.fabric8.kubernetes.api.model.authorization;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link SelfSubjectAccessReviewSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSelfSubjectAccessReviewSpecAssert<S extends AbstractSelfSubjectAccessReviewSpecAssert<S, A>, A extends SelfSubjectAccessReviewSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSelfSubjectAccessReviewSpecAssert}</code> to make assertions on actual SelfSubjectAccessReviewSpec.
   * @param actual the SelfSubjectAccessReviewSpec we want to make assertions on.
   */
  protected AbstractSelfSubjectAccessReviewSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SelfSubjectAccessReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property nonResourceAttributes so that assertions can be done on it
   */
  public NonResourceAttributesAssert nonResourceAttributes()  {
    // check that actual SelfSubjectAccessReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NonResourceAttributesAssert) assertThat(actual.getNonResourceAttributes()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nonResourceAttributes"));
  }


  /**
   * Navigates to the property resourceAttributes so that assertions can be done on it
   */
  public ResourceAttributesAssert resourceAttributes()  {
    // check that actual SelfSubjectAccessReviewSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceAttributesAssert) assertThat(actual.getResourceAttributes()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceAttributes"));
  }


}
