package io.fabric8.kubernetes.api.model.authorization;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link ResourceAttributes} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractResourceAttributesAssert<S extends AbstractResourceAttributesAssert<S, A>, A extends ResourceAttributes> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractResourceAttributesAssert}</code> to make assertions on actual ResourceAttributes.
   * @param actual the ResourceAttributes we want to make assertions on.
   */
  protected AbstractResourceAttributesAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property group so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert group()  {
    // check that actual ResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "group"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual ResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert namespace()  {
    // check that actual ResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


  /**
   * Navigates to the property resource so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resource()  {
    // check that actual ResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resource"));
  }


  /**
   * Navigates to the property subresource so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert subresource()  {
    // check that actual ResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSubresource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subresource"));
  }


  /**
   * Navigates to the property verb so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert verb()  {
    // check that actual ResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVerb()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "verb"));
  }


  /**
   * Navigates to the property version so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert version()  {
    // check that actual ResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "version"));
  }


}
