package io.fabric8.kubernetes.api.model.authorization;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link NonResourceAttributes} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNonResourceAttributesAssert<S extends AbstractNonResourceAttributesAssert<S, A>, A extends NonResourceAttributes> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNonResourceAttributesAssert}</code> to make assertions on actual NonResourceAttributes.
   * @param actual the NonResourceAttributes we want to make assertions on.
   */
  protected AbstractNonResourceAttributesAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NonResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property path so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert path()  {
    // check that actual NonResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "path"));
  }


  /**
   * Navigates to the property verb so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert verb()  {
    // check that actual NonResourceAttributes we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVerb()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "verb"));
  }


}
