package io.fabric8.kubernetes.api.model.apps;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link StatefulSetUpdateStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatefulSetUpdateStrategyAssert<S extends AbstractStatefulSetUpdateStrategyAssert<S, A>, A extends StatefulSetUpdateStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatefulSetUpdateStrategyAssert}</code> to make assertions on actual StatefulSetUpdateStrategy.
   * @param actual the StatefulSetUpdateStrategy we want to make assertions on.
   */
  protected AbstractStatefulSetUpdateStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StatefulSetUpdateStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property rollingUpdate so that assertions can be done on it
   */
  public RollingUpdateStatefulSetStrategyAssert rollingUpdate()  {
    // check that actual StatefulSetUpdateStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RollingUpdateStatefulSetStrategyAssert) assertThat(actual.getRollingUpdate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rollingUpdate"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual StatefulSetUpdateStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
