package io.fabric8.kubernetes.api.model.apps;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link StatefulSetStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatefulSetStatusAssert<S extends AbstractStatefulSetStatusAssert<S, A>, A extends StatefulSetStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatefulSetStatusAssert}</code> to make assertions on actual StatefulSetStatus.
   * @param actual the StatefulSetStatus we want to make assertions on.
   */
  protected AbstractStatefulSetStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual StatefulSetStatus's collisionCount is equal to the given one.
   * @param collisionCount the given collisionCount to compare the actual StatefulSetStatus's collisionCount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatefulSetStatus's collisionCount is not equal to the given one.
   */
  public S hasCollisionCount(Integer collisionCount) {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting collisionCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCollisionCount = actual.getCollisionCount();
    if (!Objects.areEqual(actualCollisionCount, collisionCount)) {
      failWithMessage(assertjErrorMessage, actual, collisionCount, actualCollisionCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<StatefulSetCondition, StatefulSetConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<StatefulSetCondition, StatefulSetConditionAssert> assertFactory = new AssertFactory<StatefulSetCondition, StatefulSetConditionAssert>() {
      public StatefulSetConditionAssert createAssert(StatefulSetCondition t) {
        return (StatefulSetConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<StatefulSetCondition, StatefulSetConditionAssert> answer = new NavigationListAssert<StatefulSetCondition, StatefulSetConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Verifies that the actual StatefulSetStatus's currentReplicas is equal to the given one.
   * @param currentReplicas the given currentReplicas to compare the actual StatefulSetStatus's currentReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatefulSetStatus's currentReplicas is not equal to the given one.
   */
  public S hasCurrentReplicas(Integer currentReplicas) {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting currentReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCurrentReplicas = actual.getCurrentReplicas();
    if (!Objects.areEqual(actualCurrentReplicas, currentReplicas)) {
      failWithMessage(assertjErrorMessage, actual, currentReplicas, actualCurrentReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property currentRevision so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert currentRevision()  {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCurrentRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "currentRevision"));
  }


  /**
   * Verifies that the actual StatefulSetStatus's observedGeneration is equal to the given one.
   * @param observedGeneration the given observedGeneration to compare the actual StatefulSetStatus's observedGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatefulSetStatus's observedGeneration is not equal to the given one.
   */
  public S hasObservedGeneration(Long observedGeneration) {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualObservedGeneration = actual.getObservedGeneration();
    if (!Objects.areEqual(actualObservedGeneration, observedGeneration)) {
      failWithMessage(assertjErrorMessage, actual, observedGeneration, actualObservedGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatefulSetStatus's readyReplicas is equal to the given one.
   * @param readyReplicas the given readyReplicas to compare the actual StatefulSetStatus's readyReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatefulSetStatus's readyReplicas is not equal to the given one.
   */
  public S hasReadyReplicas(Integer readyReplicas) {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting readyReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReadyReplicas = actual.getReadyReplicas();
    if (!Objects.areEqual(actualReadyReplicas, readyReplicas)) {
      failWithMessage(assertjErrorMessage, actual, readyReplicas, actualReadyReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatefulSetStatus's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual StatefulSetStatus's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatefulSetStatus's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property updateRevision so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert updateRevision()  {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUpdateRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "updateRevision"));
  }


  /**
   * Verifies that the actual StatefulSetStatus's updatedReplicas is equal to the given one.
   * @param updatedReplicas the given updatedReplicas to compare the actual StatefulSetStatus's updatedReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatefulSetStatus's updatedReplicas is not equal to the given one.
   */
  public S hasUpdatedReplicas(Integer updatedReplicas) {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting updatedReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualUpdatedReplicas = actual.getUpdatedReplicas();
    if (!Objects.areEqual(actualUpdatedReplicas, updatedReplicas)) {
      failWithMessage(assertjErrorMessage, actual, updatedReplicas, actualUpdatedReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
